VERSION 5.00
Object = "{248DD890-BB45-11CF-9ABC-0080C7E7B78D}#1.0#0"; "MSWINSCK.OCX"
Begin VB.Form PscEth 
   Caption         =   "PSC_eth sample"
   ClientHeight    =   6255
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   11610
   Icon            =   "psc-eth-vb-sample.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   6255
   ScaleWidth      =   11610
   StartUpPosition =   3  'Windows Default
   Begin VB.Timer ResendTimer 
      Enabled         =   0   'False
      Interval        =   10
      Left            =   240
      Top             =   5280
   End
   Begin VB.TextBox RepeatCounter 
      BeginProperty DataFormat 
         Type            =   1
         Format          =   "0"
         HaveTrueFalseNull=   0
         FirstDayOfWeek  =   0
         FirstWeekOfYear =   0
         LCID            =   1043
         SubFormatType   =   1
      EndProperty
      Height          =   375
      Left            =   7200
      TabIndex        =   21
      Text            =   "10"
      Top             =   3600
      Width           =   735
   End
   Begin VB.CommandButton ClearError 
      Caption         =   "Clear Error"
      Enabled         =   0   'False
      Height          =   375
      Left            =   3360
      TabIndex        =   20
      Top             =   4320
      Width           =   1215
   End
   Begin VB.CommandButton ForceInt 
      Caption         =   "Force SRQ"
      Enabled         =   0   'False
      Height          =   375
      Left            =   4920
      TabIndex        =   19
      Top             =   4320
      Width           =   1215
   End
   Begin VB.TextBox STBRegBox 
      Height          =   375
      Left            =   1680
      TabIndex        =   17
      Top             =   4320
      Width           =   1455
   End
   Begin VB.TextBox SendMultiple3 
      Height          =   375
      Left            =   4800
      TabIndex        =   15
      Text            =   "measure:power?"
      Top             =   3600
      Width           =   1455
   End
   Begin VB.TextBox SendMultiple2 
      Height          =   375
      Left            =   3240
      TabIndex        =   14
      Text            =   "measure:current?"
      Top             =   3600
      Width           =   1455
   End
   Begin VB.TextBox SendMultiple1 
      Height          =   375
      Left            =   1680
      TabIndex        =   13
      Text            =   "measure:voltage?"
      Top             =   3600
      Width           =   1455
   End
   Begin VB.CommandButton SendTCPMultiple 
      Caption         =   "Send Multiple"
      Enabled         =   0   'False
      Height          =   375
      Left            =   8040
      TabIndex        =   12
      Top             =   3600
      Width           =   1215
   End
   Begin VB.TextBox ReceiveData 
      Enabled         =   0   'False
      Height          =   375
      Left            =   1680
      TabIndex        =   8
      Top             =   3000
      Width           =   7575
   End
   Begin VB.CommandButton SendTCPSingle 
      Caption         =   "Send single"
      Default         =   -1  'True
      Enabled         =   0   'False
      Height          =   375
      Left            =   8040
      TabIndex        =   7
      Top             =   2400
      Width           =   1215
   End
   Begin VB.TextBox Senddata 
      Height          =   375
      Left            =   1680
      TabIndex        =   3
      Text            =   "*idn?"
      Top             =   2400
      Width           =   6255
   End
   Begin VB.TextBox ipaddress 
      Height          =   375
      Left            =   1680
      TabIndex        =   2
      Text            =   "10.1.0.101"
      Top             =   1800
      Width           =   1335
   End
   Begin VB.CommandButton Disconnect 
      Caption         =   "Disconnect"
      Enabled         =   0   'False
      Height          =   375
      Left            =   4440
      TabIndex        =   1
      Top             =   1800
      Width           =   975
   End
   Begin VB.CommandButton Connect 
      Caption         =   "Connect"
      Height          =   375
      Left            =   3240
      TabIndex        =   0
      Top             =   1800
      Width           =   975
   End
   Begin MSWinsockLib.Winsock psc_eth_tcp 
      Left            =   2040
      Top             =   5280
      _ExtentX        =   741
      _ExtentY        =   741
      _Version        =   393216
      RemoteHost      =   "0.0.0.0"
      RemotePort      =   8462
   End
   Begin MSWinsockLib.Winsock psc_eth_udp 
      Left            =   1200
      Top             =   5280
      _ExtentX        =   741
      _ExtentY        =   741
      _Version        =   393216
      Protocol        =   1
      RemoteHost      =   "0.0.0.0"
      LocalPort       =   8462
   End
   Begin VB.Label Label9 
      Caption         =   "Delta Elektronika BV"
      Height          =   255
      Left            =   8280
      TabIndex        =   23
      Top             =   5880
      Width           =   1695
   End
   Begin VB.Label Label8 
      Caption         =   "Repeat"
      Height          =   255
      Left            =   6480
      TabIndex        =   22
      Top             =   3720
      Width           =   855
   End
   Begin VB.Label label7 
      Caption         =   "STB Register"
      Height          =   495
      Left            =   0
      TabIndex        =   18
      Top             =   4320
      Width           =   1215
   End
   Begin VB.Label Label6 
      Caption         =   "Commands to PSC:"
      Height          =   255
      Left            =   0
      TabIndex        =   16
      Top             =   3600
      Width           =   1575
   End
   Begin VB.Label CurrentState 
      Caption         =   "Disconnected"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   6960
      TabIndex        =   11
      Top             =   1920
      Width           =   1215
   End
   Begin VB.Label Label5 
      Caption         =   "Current state:"
      Height          =   375
      Left            =   5880
      TabIndex        =   10
      Top             =   1920
      Width           =   975
   End
   Begin VB.Label Label4 
      Caption         =   "Answer:"
      Height          =   375
      Left            =   0
      TabIndex        =   9
      Top             =   3000
      Width           =   615
   End
   Begin VB.Label Label3 
      Caption         =   "PSC-ETH Sample program"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   18
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   2640
      TabIndex        =   6
      Top             =   480
      Width           =   4935
   End
   Begin VB.Label Label2 
      Caption         =   "IP Address"
      Height          =   495
      Left            =   0
      TabIndex        =   5
      Top             =   1800
      Width           =   1095
   End
   Begin VB.Label Label1 
      Caption         =   "Command to PSC:"
      Height          =   495
      Left            =   0
      TabIndex        =   4
      Top             =   2400
      Width           =   1695
   End
End
Attribute VB_Name = "PscEth"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

Private Sub ClearError_Click()
    'user clicks "clear error" button
    psc_eth_tcp.Senddata "syst:err?" & Chr(10) ' add a <line-feed>  to the data to terminater the string
    STBRegBox.Text = ""                        ' clear STB register textbox
    ReceiveData.Text = ""                      ' clear answer text box
    ForceInt.Enabled = True                    ' enable interrupt button
End Sub

Private Sub Connect_Click()
    'user connect event (button)
    psc_eth_tcp.RemoteHost = ipaddress.Text ' fill in remote address from text box
    psc_eth_tcp.Connect                     ' connect to the psc-eth to port 8462
    Disconnect.Enabled = True               ' from now one a user disconn is possible..
End Sub

Private Sub Disconnect_Click()
    'user disconnect event (button)
    psc_eth_tcp.Close                       'close TCP connection
    psc_eth_tcp_Close                       'disable buttons etc..
End Sub

Private Sub ForceInt_Click()
    'enable interrupt at filled error-queue, and create error
    psc_eth_tcp.Senddata "*SRE 4 ; typingerror" & Chr(10) 'add a <line-feed>  to the data to terminater the string
    ForceInt.Enabled = False                ' disable button
End Sub

Private Sub Form_Load()
    'initial funtion when prg starts, only enable UDP receiver,
    psc_eth_udp.Bind                        ' Set UDP receiver to listen state
End Sub

Private Sub psc_eth_tcp_Close()
    ' TCP close event received from winsock
    CurrentState.Caption = "Disconnected"   ' update state message
    Connect.Enabled = True                  ' User may re-connect
    Disconnect.Enabled = False              ' Already disconnected, disable button
    SendTCPSingle.Enabled = False                 ' Disable send button
    SendTCPMultiple.Enabled = False         ' "             "
    ForceInt.Enabled = False                ' "             "
    ClearError.Enabled = False              ' "             "
End Sub

Private Sub psc_eth_tcp_Connect()
    ' TCP connect event received from winsock
    CurrentState.Caption = "Connected"      ' Update current state message
    Connect.Enabled = False                 ' disable connect buton
    SendTCPSingle.Enabled = True            ' Enable send button
    SendTCPMultiple.Enabled = True          ' "             "
    ForceInt.Enabled = True                 ' "             "
    ClearError.Enabled = True               ' "             "
    
End Sub

Private Sub psc_eth_tcp_DataArrival(ByVal bytesTotal As Long)
    ' TCP receive event from winsock
    Dim ReceiveString As String
    Dim PrintString As String
    Dim LastPosition As Integer
    Dim Cnt As Integer
    LastPosition = 1
    psc_eth_tcp.GetData ReceiveString               ' Get receivedata from socket
    For Cnt = 1 To bytesTotal
    If Mid(ReceiveString, Cnt, 1) = Chr(10) Then    'found a chr(10) change to text "<LF>"
        PrintString = Mid(ReceiveString, LastPosition, LastPosition + Cnt - 2) & "<LF>"
        LastPosition = Cnt + 1                      'skip over <LF>
    Else
        PrintString = PrintString + Mid(ReceiveString, Cnt, 1)
    End If
    Next Cnt
    ReceiveData.Text = ReceiveData.Text & PrintString           'concatenate strings
End Sub

Private Sub psc_eth_tcp_SendProgress(ByVal bytesSent As Long, ByVal bytesRemaining As Long)
'transmit progress event fromwinsock, restart transmiter when remaining is zero.
If (bytesRemaining = 0) Then                            ' transmit queue empty??
    If (SendMultipleState = 0) Then
        SendTCPSingle.Enabled = True                    ' re-enable send button, previous message was ackd
    Else
        If (SendMultipleState = 1) Then                 ' send second multiple field
            psc_eth_tcp.Senddata SendMultiple2.Text & Chr(10) 'add a <line-feed>  to the data to terminater the string
            ResendTimer.Enabled = False                 ' stop timer, which started the first string.
        End If
        If (SendMultipleState = 2) Then                 ' send third multiple field
            psc_eth_tcp.Senddata SendMultiple3.Text & Chr(10) 'add a <line-feed>  to the data to terminater the string
        End If
        If (SendMultipleState = 3) Then                 ' end of send list ?
            If (RepeatMultiple <> 0) Then               ' more cycles?
                    SendMultipleState = 1               ' next state wil be the second string.
                    RepeatMultiple = RepeatMultiple - 1 ' decrease total amount
                    ResendTimer.Enabled = True          ' start all over again
                    ReceiveData.Text = ""               ' clear answer text box
            Else
                ResendTimer.Enabled = False             ' stop re-transmit
                SendMultipleState = 0                   ' reset state, end of transmission
                SendTCPMultiple.Enabled = True          ' re-enable send button
            End If
            RepeatCounter.Text = RepeatMultiple         ' update textbox with current counter
        Else
            SendMultipleState = SendMultipleState + 1   ' else increase state
        End If
    End If
End If
End Sub

Private Sub psc_eth_udp_DataArrival(ByVal bytesTotal As Long)
' UDP event received data from winsock
    Dim tempString As String
    Dim STBRegister As Byte
    psc_eth_udp.GetData tempString
    If Asc(Left(tempString, 1)) = 1 Then        ' first byte must be 1
        STBRegister = Asc(Right(tempString, 1)) ' fill the STB register from the second byte of the UDP message.
        STBRegBox.Text = STBRegister
        MsgBox "SRQ received!"                  ' signal user that a SRQ has arrived!
    End If
End Sub

Private Sub ResendTimer_Timer()
    'the 10 ms timer has elapsed
    psc_eth_tcp.Senddata SendMultiple1.Text & Chr(10) 's end first multipe string entry
End Sub

Private Sub SendTCPMultiple_Click()
    'user pressed "Send Multiple" button
    RepeatMultiple = RepeatCounter.Text     ' Get repeatcounter from textbox
    ReceiveData.Text = ""                   ' Clear answer textbox
    SendMultipleState = 1                   ' Start with first entry
    SendTCPMultiple.Enabled = False         ' Disable send button
    ResendTimer.Enabled = True              ' Start transmitting first entry
End Sub

Private Sub SendTCPSingle_Click()
    'user pressed "Send Multiple" button
    SendMultipleState = 0
    ReceiveData.Text = ""                               ' clear answer textbox
    If (Len(Senddata.Text)) Then                        ' only send data if ther is anything to send
        psc_eth_tcp.Senddata Senddata.Text & Chr(10)    ' add a <line-feed>  to the data to terminater the string
    Else
        MsgBox "No data to send, fill datafield!"       ' signal user he did not fill in anything <NULL-STRING>
    End If
    SendTCPSingle.Enabled = False                       ' disable send button
End Sub


